<?php 
    $page_title=(isset($_GET['section_id'])) ? 'Edit Section' : 'Create Section';
    include("includes/header.php");
    require("includes/lb_helper.php");
    require("language/language.php");
    require_once("thumbnail_images.class.php");
    
    $page_save=(isset($_GET['section_id'])) ? 'Save' : 'Create';
    
    $audio_qry="SELECT * FROM tbl_audio ORDER BY tbl_audio.id DESC"; 
    $audio_result=mysqli_query($mysqli,$audio_qry); 
    
    $category_qry="SELECT * FROM tbl_category ORDER BY tbl_category.cid DESC"; 
    $category_result=mysqli_query($mysqli,$category_qry);
    
    $cou_qry="SELECT * FROM tbl_countries ORDER BY tbl_countries.sid DESC";
    $cou_result=mysqli_query($mysqli,$cou_qry); 
    
    $radio_qry="SELECT * FROM tbl_radio ORDER BY tbl_radio.id DESC"; 
    $radio_result=mysqli_query($mysqli,$radio_qry);
    
    $podcast_qry="SELECT * FROM tbl_podcast ORDER BY tbl_podcast.pid DESC"; 
    $podcast_result=mysqli_query($mysqli,$podcast_qry); 

    if(isset($_POST['submit']) and isset($_GET['add'])){
        
        $section_type = trim($_POST['section_type']);
        
        if($section_type=='category'){
            $post_ids = implode(',',$_POST['cat_post_id']);
        } else if($section_type=='countries'){
            $post_ids = implode(',',$_POST['countries_post_id']);
        } else if($section_type=='radio'){
            $post_ids = implode(',',$_POST['radio_post_id']);
        } else if($section_type=='podcasts'){
            $post_ids = implode(',',$_POST['podcast_post_id']);
        } else if($section_type=='banner_ads'){
            $post_ids = "";
        }
        
        $data = array( 
            'section_name'  =>  $_POST['section_name'],
            'section_type'  =>  $section_type,
            'post_ids'  =>  $post_ids
        );
        
        $qry = Insert('tbl_home_sections',$data);
        
        $_SESSION['msg']="10";
        $_SESSION['class']='success'; 
        header( "Location:manage_sections.php");
        exit;			 
    }
    
    if(isset($_GET['section_id'])){
        $qry="SELECT * FROM tbl_home_sections where id='".$_GET['section_id']."'";
        $result=mysqli_query($mysqli,$qry);
        $row=mysqli_fetch_assoc($result);
    }
    
    if(isset($_POST['submit']) and isset($_POST['section_id'])){
        
        $section_type = trim($_POST['section_type']);
        
        if($section_type=='category'){
            $post_ids = implode(',',$_POST['cat_post_id']);
        } else if($section_type=='countries'){
            $post_ids = implode(',',$_POST['countries_post_id']);
        } else if($section_type=='radio'){
            $post_ids = implode(',',$_POST['radio_post_id']);
        } else if($section_type=='podcasts'){
            $post_ids = implode(',',$_POST['podcast_post_id']);
        } else if($section_type=='banner_ads'){
            $post_ids = "";
        }
        
        $data = array( 
            'section_name'  =>  $_POST['section_name'],
            'section_type'  =>  $section_type,
            'post_ids'  =>  $post_ids
        );
        
        $banner_edit=Update('tbl_home_sections', $data, "WHERE id = '".$_POST['section_id']."'");
        
        $_SESSION['msg']="11";
        $_SESSION['class']='success'; 
        header( "Location:create_sections.php?section_id=".$_POST['section_id']);
        exit;
    }
?>

<!-- Start: main -->
<main id="nsofts_main">
    <div class="nsofts-container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item d-inline-flex"><a href="dashboard.php"><i class="ri-home-4-fill"></i></a></li>
                <li class="breadcrumb-item d-inline-flex active" aria-current="page"><?php echo (isset($page_title)) ? $page_title : "" ?></li>
            </ol>
        </nav>
            
        <div class="row g-4">
            <div class="col-12">
                <div class="card h-100">
                    <div class="card-body p-4">
                        <h5 class="mb-3"><?=$page_title ?></h5>
                        <form action="" name="addeditalbum" method="POST" enctype="multipart/form-data">
                            <input  type="hidden" name="section_id" value="<?=(isset($_GET['section_id'])) ? $_GET['section_id'] : ''?>" />
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Section Title</label>
                                <div class="col-sm-10">
                                    <input type="text" name="section_name" class="form-control" value="<?php if(isset($_GET['section_id'])){echo $row['section_name'];}?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Section Type</label>
                                <div class="col-sm-10">
                                    <select name="section_type" id="section_type" class="nsofts-select" required>
                                        <option value="">--Select Type --</option>
                                         <?php if(isset($_GET['section_id'])){ ?>
                                            <option value="category" <?php if($row['section_type']=='category'){?>selected<?php }?>>Categories</option>
                                            <option value="countries" <?php if($row['section_type']=='countries'){?>selected<?php }?>>Countries</option>
                                            <option value="radio" <?php if($row['section_type']=='radio'){?>selected<?php }?>>Radio</option>
                                            <option value="podcasts" <?php if($row['section_type']=='podcasts'){?>selected<?php }?>>Podcasts</option>
                                         <?php } else { ?>
                                            <option value="category">Categories</option>
                                            <option value="countries">Countries</option>
                                            <option value="radio">Radio</option>
                                            <option value="podcasts">Podcasts</option>
                                         <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_cat" class="mb-3 row" <?php if(isset($_GET['section_id'])){?> <?php if($row['section_type']!='category'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Categories</label>
                                <div class="col-sm-10">
                                    <select name="cat_post_id[]" id="cat_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Categories--</option>
                                        <?php while($category_row=mysqli_fetch_array($category_result)){ ?> 
                                            <option value="<?php echo $category_row['cid'];?>" <?php if(in_array($category_row['cid'], explode(",",$row['post_ids']))){?>selected<?php }?>><?php echo $category_row['category_name'];?></option>                           
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_countries" class="mb-3 row" <?php if(isset($_GET['section_id'])){?> <?php if($row['section_type']!='countries'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Countries</label>
                                <div class="col-sm-10">
                                    <select name="countries_post_id[]" id="countries_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Countries--</option>
                                        <?php while($cou_row=mysqli_fetch_array($cou_result)){ ?> 
                                            <option value="<?php echo $cou_row['sid'];?>" <?php if(in_array($cou_row['sid'], explode(",",$row['post_ids']))){?>selected<?php }?>><?php echo $cou_row['countries_name'];?></option>                           
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_radio"  class="mb-3 row" <?php if(isset($_GET['section_id'])){?> <?php if($row['section_type']!='radio'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Radio</label>
                                <div class="col-sm-10">
                                    <select name="radio_post_id[]" id="radio_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Radio--</option>
                                        <?php while($radio_row=mysqli_fetch_array($radio_result)){ ?> 
                                            <option value="<?php echo $radio_row['id'];?>" <?php if(in_array($radio_row['id'], explode(",",$row['post_ids']))){?>selected<?php }?>><?php echo $radio_row['radio_title'];?></option>                           
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id="section_podcasts"  class="mb-3 row" <?php if(isset($_GET['section_id'])){?> <?php if($row['section_type']!='podcasts'){?>style="display:none;"<?php }?> <?php } else { ?>style="display:none;"<?php }?>>
                                <label class="col-sm-2 col-form-label">Add Podcast</label>
                                <div class="col-sm-10">
                                    <select name="podcast_post_id[]" id="podcast_post_id" class="nsofts-select" multiple="multiple">
                                        <option value="">--Select Podcast--</option>
                                        <?php while($podcast_row=mysqli_fetch_array($podcast_result)){ ?> 
                                            <option value="<?php echo $podcast_row['pid'];?>" <?php if(in_array($podcast_row['pid'], explode(",",$row['post_ids']))){?>selected<?php }?>><?php echo $podcast_row['podcast_name'];?></option>                           
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">&nbsp;</label>
                                <div class="col-sm-10">
                                    <button type="submit" name="submit" class="btn btn-primary" style="min-width: 120px;"><?=$page_save?></button>
                                </div>
                            </div>
                            
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<!-- End: main -->
    
<?php include("includes/footer.php");?> 

<script type="text/javascript">
    $(document).ready(function(e) {
        $("#section_type").change(function(){
          var type=$("#section_type").val();
          if(type=="category"){
            $("#section_cat").show();
            $("#section_countries").hide();
            $("#section_radio").hide();
            $("#section_podcasts").hide();
            
          } else if(type=="countries"){
            $("#section_cat").hide();
            $("#section_countries").show();
            $("#section_radio").hide();
            $("#section_podcasts").hide();
            
          } else if(type=="radio"){
            $("#section_cat").hide();
            $("#section_countries").hide();
            $("#section_radio").show();
            $("#section_podcasts").hide();
            
          } else if(type=="podcasts"){
            $("#section_cat").hide();
            $("#section_countries").hide();
            $("#section_radio").hide();
            $("#section_podcasts").show();
            
          } else {
            $("#section_cat").hide();
            $("#section_countries").hide();
            $("#section_radio").hide();
            $("#section_podcasts").hide();
            
          }
        });
    });
</script>